/**
 * `OAuth2Error` error.
 *
 * @api public
 */
function OAuth2Error(message, code, uri, status) {
  Error.call(this);
  this.message = message;
  this.code = code || 'server_error';
  this.uri = uri;
  this.status = status || 500;
}

/**
 * Inherit from `Error`.
 */
OAuth2Error.prototype.__proto__ = Error.prototype;


/**
 * Expose `OAuth2Error`.
 */
module.exports = OAuth2Error;
