const express = require('express');

const app = express();

app.use('/components', express.static('src'));
app.use('/bower_components', express.static('bower_components'));
app.use('/images', express.static('resources/images'));
app.use('/data', express.static('resources/data'));
app.get('/', (req, res) => res.sendFile(`${__dirname}/index.html`));
app.get('/favicon.ico', (req, res) => res.sendFile(`${__dirname}/favicon.ico`));
app.get('/manifest.json',
    (req, res) => res.sendFile(`${__dirname}/manifest.json`));

app.listen(3000, () => console.log('Server running on port 3000'));