/**
 * @customElement
 * @polymer
 */
class PlanarDeck extends Polymer.Element {
  static get is() { return 'planar-deck'; }
  
  static get properties() {
    return {
      cards: Array,
      cardData: Array,
      nextThreeCards: {
        type: Array,
        computed: 'computeNextThreeCards_(cards.*)',
        readOnly: true,
      },
      topFivePlanes: Array,
    };
  }
  
  computeNextThreeCards_(cards) {
    const names = cards.base.slice(0, 3);
    const picked = names.map((name) =>
        this.cardData.find((card) => card.name === name));
    return picked;
  }
  
  tappedDeck() {
    const top = this.shift('cards');
    const card = this.cardData.find((card) => card.name === top);
    this.dispatchEvent(new CustomEvent('planeswalk', {
      bubbles: true,
      composed: true,
      detail: card,
    }));
  }
  
  handlePoolsOfBecoming() {
    this.$.poolsOfBecomingDialog.open();
  }
  
  handlePoolsOfBecomingClosed() {
    const top3 = this.splice('cards', 0, 3);
    this.splice('cards', this.cards.length, 0, ...top3);
  }
  
  handleInterplanarTunnel() {
    this.topFivePlanes = [];
    let planeCount = 0;
    let nextCard;
    const findCard = (card) => card.name === nextCard;
    while (planeCount < 5) {
      nextCard = this.shift('cards');
      const nextCardData = this.cardData.find(findCard);
      this.push('topFivePlanes', nextCardData);
      planeCount = this.topFivePlanes.reduce((memo, curr) => {
        return memo + (curr.isPhenomenon ? 0 : 1);
      }, 0);
    }
    setTimeout(() => {
      const div = this.$.interplanarTunnelDialog.children[0];
      const divChildren = [...div.childNodes];
      let next;
      const insertNodes = (n) => div.insertBefore(n, next);
      for (let i = 0; i < divChildren.length; i++) {
        if (divChildren[i].nodeName === 'PAPER-ICON-BUTTON') {
          i++;
          let text = divChildren[i].nodeValue;
          const nodes = [];
          while (text.length) {
            if (text.indexOf('{') < 0) {
              nodes.push(document.createTextNode(text));
              break;
            }
            let data = text.substring(0, text.indexOf('{'));
            text = text.substring(data.length);
            if (data.length) {
              nodes.push(document.createTextNode(data));
            }
            data = text.substring(0, text.indexOf('}') + 1);
            text = text.substring(data.length);
            if (data.length) {
              const img = document.createElement('img');
              if (data === '{CHAOS}') {
                img.src = '/images/chaos.png';
                img.classList.add('chaos');
                nodes.push(img);
              } else {
                img.src =
                    `/images/mana/${data.substring(1, data.length - 1)}.svg`;
                img.classList.add('mana');
                nodes.push(img);
              }
            }
          }
          div.removeChild(divChildren[i]);
          next = divChildren[i + 1];
          nodes.forEach(insertNodes);
        }
      }
      this.$.interplanarTunnelDialog.open();
    });
  }
  
  handleSelectPlane(e) {
    const keeper = this.topFivePlanes[e.model.index];
    const trash = this.topFivePlanes.filter((p, i) => i !== e.model.index)
        .map((p) => p.name);
    this.push('cards', ...trash);
    this.unshift('cards', keeper.name);
    this.$.interplanarTunnelDialog.close();
  }
  
  getChaos(card) {
    const chaosLine = card.text.split('\n')
        .find((line) => line.indexOf('Whenever you roll {CHAOS}') === 0);
    return chaosLine && chaosLine.replace('Whenever you roll {CHAOS}, ', '');
  }
}

window.customElements.define(PlanarDeck.is, PlanarDeck);